#!/usr/bin/python3
# ==============================================================================================
# Hash management
#  Keeps Data in a stack for a defined number of iteration
#  add2Dict(data)  Adds data to stack and return True if not already in stack
#  cleanDict()     Process the stack cleaning
# ==============================================================================================
class Hash:
    """RTTY_Hash.Hash Class: Manage a stack of already seen things"""
    # ------------------------------------------------------------------------------------------
    def __init__(self,itr=2,dbg=False):
        self._dbg=dbg
        self.dct={}
        self._itr=itr
    # ------------------------------------------------------------------------------------------
    def __repr__(self):
        return "itr:{}".format(self._itr)
    # ------------------------------------------------------------------------------------------
    @property 
    def dbg(self):
        return self._dbg
    @dbg.setter
    def dbg(self,x):
        self._dbg=x
    # -----------------------------------------------------------------------------------------
    def add2Dict(self,hsh):
        #---------------------------------------------------------------------------------------
        if hsh in self.dct:             # Already seen
            self.dct[hsh]=self._itr     # Reset flag
            return False
        #---------------------------------------------------------------------------------------
        else:                           # First seen
            self.dct[hsh]=self._itr     # Reset flag
            return True
    #_-------------------------------------------------------------------------------------------
    def getDict(self):
        lst=""
        for key in self.dct:
            lst=lst+"|"+str(key)
        if (lst != ""):
            lst=lst+"|"
        return(lst)
    #_-------------------------------------------------------------------------------------------
    def cleanDict(self):
        try:
            old={}
            for key in self.dct:
                self.dct[key]-=1
                if (self.dct[key]==0):
                    old[key]="D"
                    if (self._dbg): print("WARN:  DELETE "+str(key))
            for key in old:
                self.dct.pop(key)
        except Exception as e:
            if (self._dbg): print("ERROR: DICT ({0})".format(e))
        return
    #-------------------------------------------------------------------------------------------
    def Test(self):
        print("TEST:  HASH Dictionnary") 
        try:
            data=["A","B","C","D"]
            iter=4
            for i in range(5):
                for j in range(iter):
                    print("Add "+data[j])
                    self.add2Dict(data[j])
                    print(self.getDict())
                iter-=1
                print("Clear Dict")
                self.cleanDict()
                print(self.getDict())
        except:
            print("-> Not passed")
            pass
# ==============================================================================================
if __name__ == '__main__':
    import sys
    import signal
    from inspect import getdoc
    def signal_term_handler(signal, frame):
        sys.exit(0)
    signal.signal(signal.SIGINT,  signal_term_handler)
    signal.signal(signal.SIGTERM, signal_term_handler)
    print(getdoc(Hash))
    this=Hash()
    state=this.dbg
    this.dbg=True
    this.Test()
    this.dbg=state
# ==============================================================================================
