#!/usr/bin/python3 -u
import sys, getopt
import tty, termios
import select
sys.path.insert(0, './lib')
import RTTY_FSK
import RTTY_Serial
import RTTY_ITA2
import RTTY_Print
# ==============================================================================================
def usage(argv):
    print(argv[0]+" {-s|--serial}{-a|--audio}{-u|--us}{-f|--fr}")
    print(" -s  Serial mode   (default)")
    print(" -a  Audio  mode")
    print(" -u  US ITA2 Table (default)")	
    print(" -f  FR ITA2 Table")
    sys.exit(2)
# ==============================================================================================
def main(argv):
    # ------------------------------------------------------------------------------------------
    try:
       opts,args = getopt.getopt(argv[1:],"saufh",["serial","audio","us","fr","help"])
    except:
       usage(argv)
       sys.exit(2)
    # ------------------------------------------------------------------------------------------
    tbl=0
    tbm=["US","FR"]
    aud=0
    aum=["Serial","Audio"]
    for opt,arg in opts:
       if opt in ("-h","--help"):
           usage(argv)
           sys.exit(2)
       # ---------------------------------------------------------------------------------------
       if opt in ("-u","--us"):     tbl=0
       if opt in ("-f","--fr"):     tbl=1
       # ---------------------------------------------------------------------------------------
       if opt in ("-s","--serial"): aud=0
       if opt in ("-a","--audio"):  aud=1
    # ------------------------------------------------------------------------------------------
    print("ITA2 characters terminal")
    print(" Using "+tbm[tbl]+" table")
    print(" Using "+aum[aud]+" mode")
    if (aud==1): print(" FSK decoding not yet implemented")
    print("Hit CTRL-C to exit...")
    # ------------------------------------------------------------------------------------------
    # Set local TTY console input to non blocking character read
    # ------------------------------------------------------------------------------------------
    fd=sys.stdin.fileno()
    st=termios.tcgetattr(fd)
    tty.setraw(fd)
    # ------------------------------------------------------------------------------------------
    # Get an ITA2 converter and a colour ouput
    # ------------------------------------------------------------------------------------------
    ita=RTTY_ITA2.Ita2()
    ita.table=tbl
    # ------------------------------------------------------------------------------------------
    col=RTTY_Print.Print()
    # ------------------------------------------------------------------------------------------
    # Get a serial or audio link
    # ------------------------------------------------------------------------------------------
    if (aud==0):
        ser=RTTY_Serial.Serial()
#       ita.dbg=True
#       ser.dbg=True
        ser.timeout=None
        ser.Open()
    else:
        fsk=RTTY_FSK.Fsk()
        fsk.Open()
        buf=""
        run=False
    # ------------------------------------------------------------------------------------------
    while(True):
        # --------------------------------------------------------------------------------------
        # Keyboard character pressed
        # --------------------------------------------------------------------------------------
        if (select.select([sys.stdin],[],[],0)==([sys.stdin],[],[])):
            c=sys.stdin.read(1)
            # ----------------------------------------------------------------------------------
            if (ord(c)==3): 
                termios.tcsetattr(fd,termios.TCSADRAIN,st)
                if (aud==0):    ser.Close()
                else:           fsk.Close()
                print("Exit")
                print()
                sys.exit(1)
            # ----------------------------------------------------------------------------------
            if (c):
                # ------------------------------------------------------------------------------
                # Serial: no buffering required
                # ------------------------------------------------------------------------------
                if (aud==0):
                    ser.Print(ita.toIta2(c))
                # ------------------------------------------------------------------------------
                # FSK   : need buffering and no encoding
                # ------------------------------------------------------------------------------
                else:
                    buf=buf+c
                    if (c=='\r'): 
                        if (fsk.ita2extern): buf=ita.toIta2(buf)
                        fsk.Print(buf)
                        buf=""
                # ------------------------------------------------------------------------------
                if (c=='\r'): print(c)
                else:         col.print(c.upper(),col.BLUE)
        # --------------------------------------------------------------------------------------
        # Serial character receiver 
        # --------------------------------------------------------------------------------------
        if (aud==0):
            if (ser.in_waiting!=0):
                dat=ser.Read(ser.in_waiting)
                if (dat):
                    msg=ita.toAscii(dat)
                    col.print(msg.upper(),col.RED)
    # ------------------------------------------------------------------------------------------
# ==============================================================================================
if __name__ == '__main__':
    main(sys.argv)
# ==============================================================================================
