// -------------------------------------------------------------------------
// Stolen from http://fabacademy.org/archives/2015/doc/WebSocketConsole.html
// -------------------------------------------------------------------------
$(document).ready(function(){
    // ---------------------------------------------------------------------
    var st_data = 1;		// First data received after a new line
    var tb_code = 0;		// Default US Table 
    var ts_mode = 0;		// Default no time stamp
    var nl_mode = 0;		// Send on newline
    // ---------------------------------------------------------------------
    var rx_data = $('#rx_data');
    var tx_sent = $('#tx_sent');
    var tx_data = $('#tx_data');
    var st_info = $('#st_info');
    // ---------------------------------------------------------------------
    var socket = new WebSocket("ws://" + location.host + "/ws");
    // ---------------------------------------------------------------------
    socket.onopen = function(){  
      document.getElementById('st_info').innerHTML = 'Connected';
      console.log("connected"); 
      tx_data.focus();
    }; 
    // ---------------------------------------------------------------------
    socket.onmessage = function (message) {
      console.log("receiving: " + message.data);
      switch (message.data.substr(0,3)) {
        case "[D]" :
         var data = message.data.substr(3);
         if (ts_mode==1) {
            var ts = "["+(new Date).toTimeString().slice(0,8)+"] ";
            if (st_data) {
               rx_data.append(ts);
            }
            else {
               data = data.replace(/\r/gm,'\r'+ts);
            }
         }
         data = data.replace(/\n/g,'<br\>');
         rx_data.append(data);
         st_data=0;
         break;
        case "[I]" :
         document.getElementById('st_vers').innerHTML = message.data.substr(3,5);
         break;
        default    :
         break;
      }
    };
    // ---------------------------------------------------------------------
    socket.onclose = function(){
      document.getElementById('st_info').innerHTML = 'Disconnected';
      console.log("disconnected"); 
    };
    // ---------------------------------------------------------------------
    var sendMessage = function(message) {
      console.log("sending:" + message.data);
      socket.send(message.data);
    };
    // ---------------------------------------------------------------------
    // GUI Stuff
    // ---------------------------------------------------------------------
    function sendit() {
      var data = tx_data.val();
      data = data.replace(/\r\n/g,'\r');
      data = data.replace(  /\n/g,'\r');
      text = data.replace(/\r/g,'\r\n');
      data = data.replace(/\r$/g,'');
      sendMessage({'data':"[D]"+text});
      if (ts_mode==1) {
         var ts = "["+(new Date).toTimeString().slice(0,8)+"] ";
         data = data.replace(/^/gm,ts);
      }
      data = data.replace(/\r/g,'<br\>');
      data = data+'<br\>';	
      tx_sent.append(data);
      tx_sent.scrollTop(tx_sent[0].scrollHeight);
      tx_data.focus();
      tx_data.val('');
    }
    // ---------------------------------------------------------------------
    // Send data text
    // ---------------------------------------------------------------------
    $("#tx_send").click(function(ev) {
      console.log("tx send"); 
      ev.preventDefault();
      sendit();
    });
    // ---------------------------------------------------------------------
    // Send on CR
    // ---------------------------------------------------------------------
    $("#tx_data").keypress(function (ev) {
      if (nl_mode==1) {
        var keycode = ev.keyCode || ev.which;
        if(keycode == 10) {
          ev.preventDefault();
          console.log("tx send (NL)"); 
        }
        if(keycode == 13) {
          ev.preventDefault();
          console.log("tx send (CR)"); 
          sendit();
        }
      }
    });
    // ---------------------------------------------------------------------
    // Clear RX window
    // ---------------------------------------------------------------------
    $("#rx_clear").click(function(ev) {
      console.log("rx clear"); 
      rx_data.empty()
      tx_data.focus();
    });
    // ---------------------------------------------------------------------
    // Clear TX window
    // ---------------------------------------------------------------------
    $("#tx_clear").click(function(ev) {
      console.log("tx clear"); 
      tx_sent.empty()
      tx_data.val('')
      tx_data.focus();
    });
    // ---------------------------------------------------------------------
    // Process table option change
    // ---------------------------------------------------------------------
    $('input[name="tb_code"]').on('click change', function(e) {
      var tb_code = document.querySelector('input[name="tb_code"]:checked').value;
      console.log(tb_code); 
      tx_data.focus();
      sendMessage({'data':"[T]"+tb_code});
    });
    // ---------------------------------------------------------------------
    // Process timestamp option change
    // ---------------------------------------------------------------------
    $('input[name="ts_mode"]').on('click change', function(e) {
      ts_mode = document.querySelector('input[name="ts_mode"]:checked').value;
      console.log(ts_mode); 
      tx_data.focus();
    });
    // ---------------------------------------------------------------------
    // Process newline option change
    // ---------------------------------------------------------------------
    $('input[name="nl_mode"]').on('click change', function(e) {
      nl_mode = document.querySelector('input[name="nl_mode"]:checked').value;
      console.log(nl_mode); 
      tx_data.focus();
    });
    // ---------------------------------------------------------------------
});
