#!/usr/bin/python3
# ==============================================================================================
# Termial color managment
# Stolen from http://blog.mathieu-leplatre.info/colored-output-in-console-with-python.html
# ----------------------------------------------------------------------------------------------
class Print:
    """RTTY_Print.Print Class: Print with ANSI colors on stdout"""
    # ------------------------------------------------------------------------------------------
    BLACK, RED, GREEN, YELLOW, BLUE, MAGENTA, CYAN, WHITE = range(8)
    # ------------------------------------------------------------------------------------------
    def __init__(self):
        import sys
        self._has_colours = self.has_colours(sys.stdout)
    # ------------------------------------------------------------------------------------------
    # Following from Python cookbook, #475186
    # ------------------------------------------------------------------------------------------
    def has_colours(self, stream):
        if not hasattr(stream, "isatty"):  return False
        if not stream.isatty():            return False # auto color only on TTYs
        try:
            import curses
            curses.setupterm()
            return curses.tigetnum("colors") > 2
        except:
            # guess false in case of error
            return False
    # ------------------------------------------------------------------------------------------
    def print(self, text, colour=WHITE):
        import  sys
        if self._has_colours:
            seq = "\x1b[1;%dm" % (30+colour) + text + "\x1b[0m"
            sys.stdout.write(seq)
        else:
            sys.stdout.write(text)
        sys.stdout.flush()
    #-------------------------------------------------------------------------------------------
    def Test(self):
        print("TEST:  Print ANSI functions")
        try:
            for i in range(8):
                self.print("RTTY_Print.Print Class", i)
                print()
        except:
            print("-> Not passed")      
# ==============================================================================================
if __name__ == '__main__':
    import sys
    import signal
    from inspect import getdoc
    def signal_term_handler(signal, frame):
        sys.exit(0)
    signal.signal(signal.SIGINT,  signal_term_handler)
    signal.signal(signal.SIGTERM, signal_term_handler)
    print(getdoc(Print))
    prt = Print()
    prt.Test()
# ==============================================================================================
