# ----------------------------------------------------------------
# Next configuration step. Should be made through the 'pi' account
# ----------------------------------------------------------------
# Setting account 
# ----------------------------------------------------------------
echo "Setting name and adding the 'rtty' account"
sudo echo "RaspTTY" >/etc/hostname
sudo adduser --gecos "RTTY User" rtty
sudo adduser rtty sudo
sudo echo > /etc/motd
sudo cp -a ./issue /etc/issue
sudo cp -a ./issue /etc/issue.net
# ----------------------------------------------------------------
echo "Upgrade distribution"
sudo apt-get update
sudo apt-get upgrade
# ----------------------------------------------------------------
# Setting network static IP if required
# ----------------------------------------------------------------
echo "Copying network interfaces config file"
sudo cp -a ./interfaces /etc/network/interfaces
# ----------------------------------------------------------------
# Install python dependencies
# ----------------------------------------------------------------
echo "Install python modules"
sudo apt-get install python3-lxml
sudo apt-get install python3-pip
sudo apt-get install python3-rpi.gpio
# ----------------------------------------------------------------
python3 -m pip install pyserial
python3 -m pip install tornado
# ----------------------------------------------------------------
# Install utilities
# ----------------------------------------------------------------
#  minimodem		
# ----------------------------------------------------------------
echo "Install minimodem utility"
sudo apt-get install minimodem
echo "Change with our own version (disable ITA2 convert)"
cp minimodem /usr/bin/minimodem
# ----------------------------------------------------------------
#  omxplayer
# ----------------------------------------------------------------
echo "Install omxplayer utility"
sudo apt-get install omxplayer
# ----------------------------------------------------------------
# Set services
# ----------------------------------------------------------------
echo "Install app and web services"
sudo ln -s ./start-rasptty-app /etc/rc.d
sudo update-rc.d start-rasptty-app defaults
# ----------------------------------------------------------------
echo "Don't forget to reboot system"

