#!/usr/bin/python3
# ----------------------------------------------------------------------------------------------
import sys
sys.path.insert(0, 'src')
sys.path.insert(0, '../src')
import RTTY_Serial
import RTTY_ITA2
# ----------------------------------------------------------------------------------------------
import time
import multiprocessing
# ----------------------------------------------------------------------------------------------
class SerialProcess(multiprocessing.Process):
    # ------------------------------------------------------------------------------------------
    def __init__(self, input_queue, output_queue):
        multiprocessing.Process.__init__(self)
        self.input_queue = input_queue
        self.output_queue = output_queue
        self.ita = RTTY_ITA2.Ita2()
        self.ita.table = 0
        self.sp = ser=RTTY_Serial.Serial()
        self.sp.timeout=None
        self.sp.Open()
    # ------------------------------------------------------------------------------------------
    def close(self):
        self.sp.Close()
    # ------------------------------------------------------------------------------------------
    def run(self):
        while True:
            # look for incoming tornado request
            if not self.input_queue.empty():
                dat = self.input_queue.get()
                # print("writing to   TTY: " + dat)
                self.sp.Print(self.ita.toIta2(dat))
 
            # look for incoming serial data
            if (self.sp.in_waiting != 0):
                dat = self.sp.Read(self.sp.in_waiting)
                if (dat):
                    msg = self.ita.toAscii(dat)
                    # print("reading from TTY: " + msg)
                    self.output_queue.put(msg)
    # ------------------------------------------------------------------------------------------
# ==============================================================================================
