VERSION 5.00
Begin VB.Form Test 
   Caption         =   "ReceiverCtl Test"
   ClientHeight    =   1665
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   5385
   KeyPreview      =   -1  'True
   LinkTopic       =   "Form1"
   ScaleHeight     =   1665
   ScaleWidth      =   5385
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton Dialog 
      Caption         =   "Config Driver"
      Height          =   495
      Left            =   1800
      TabIndex        =   1
      ToolTipText     =   "Add/Configure drivers"
      Top             =   0
      Width           =   735
   End
   Begin VB.CheckBox Coupling 
      Height          =   255
      Left            =   1560
      TabIndex        =   30
      ToolTipText     =   "Forward changes from one receiver to any other"
      Top             =   0
      Width           =   255
   End
   Begin VB.TextBox DeltaF 
      Alignment       =   1  'Right Justify
      Height          =   285
      Left            =   2760
      TabIndex        =   28
      Text            =   "0"
      Top             =   840
      Width           =   495
   End
   Begin VB.ListBox Filter 
      Height          =   450
      Left            =   3720
      TabIndex        =   24
      Top             =   600
      Width           =   1695
   End
   Begin VB.ListBox Att 
      Height          =   450
      Left            =   4680
      TabIndex        =   22
      Top             =   1200
      Width           =   735
   End
   Begin VB.ListBox NB 
      Height          =   450
      Left            =   3360
      TabIndex        =   20
      Top             =   1200
      Width           =   855
   End
   Begin VB.ListBox Agc 
      Height          =   450
      Left            =   1920
      TabIndex        =   18
      Top             =   1200
      Width           =   975
   End
   Begin VB.ListBox Mode 
      Height          =   450
      Left            =   600
      TabIndex        =   15
      Top             =   1200
      Width           =   855
   End
   Begin VB.TextBox Freq 
      Alignment       =   1  'Right Justify
      Height          =   285
      Left            =   1920
      TabIndex        =   13
      Top             =   840
      Width           =   855
   End
   Begin VB.CommandButton Local 
      Caption         =   "Local"
      Height          =   255
      Left            =   3480
      TabIndex        =   10
      ToolTipText     =   "Release control of current connected receiver"
      Top             =   240
      Width           =   975
   End
   Begin VB.CommandButton Remote 
      Caption         =   "Remote"
      Height          =   255
      Left            =   2520
      TabIndex        =   9
      ToolTipText     =   "Take control of current connected receiver"
      Top             =   240
      Width           =   975
   End
   Begin VB.CommandButton Disconnect 
      Caption         =   "Disconnect"
      Height          =   255
      Left            =   3480
      TabIndex        =   4
      ToolTipText     =   "Disconnect current receiver"
      Top             =   0
      Width           =   975
   End
   Begin VB.CommandButton Connect 
      Caption         =   "Connect"
      Height          =   255
      Left            =   2520
      TabIndex        =   3
      ToolTipText     =   "Connect current receiver"
      Top             =   0
      Width           =   975
   End
   Begin VB.ListBox Driver 
      Height          =   450
      ItemData        =   "TstCTL.frx":0000
      Left            =   600
      List            =   "TstCTL.frx":0002
      TabIndex        =   2
      ToolTipText     =   "Select current receiver"
      Top             =   0
      Width           =   855
   End
   Begin VB.Label SMet 
      Alignment       =   1  'Right Justify
      BorderStyle     =   1  'Fixed Single
      Height          =   255
      Left            =   4560
      TabIndex        =   29
      ToolTipText     =   "SMeter"
      Top             =   240
      Width           =   855
   End
   Begin VB.Label Label 
      Caption         =   "FrqMin"
      Height          =   255
      Index           =   9
      Left            =   0
      TabIndex        =   27
      Top             =   960
      Width           =   615
   End
   Begin VB.Label FrqMin 
      Alignment       =   1  'Right Justify
      BorderStyle     =   1  'Fixed Single
      Height          =   255
      Left            =   600
      TabIndex        =   26
      Top             =   960
      Width           =   855
   End
   Begin VB.Label BFO 
      Alignment       =   1  'Right Justify
      BorderStyle     =   1  'Fixed Single
      Height          =   255
      Left            =   2760
      TabIndex        =   25
      Top             =   600
      Width           =   495
   End
   Begin VB.Label Label 
      Caption         =   "FLT"
      Height          =   255
      Index           =   8
      Left            =   3360
      TabIndex        =   23
      Top             =   645
      Width           =   615
   End
   Begin VB.Label Label 
      Caption         =   "ATT"
      Height          =   255
      Index           =   7
      Left            =   4320
      TabIndex        =   21
      Top             =   1260
      Width           =   615
   End
   Begin VB.Label Label 
      Caption         =   "NB"
      Height          =   255
      Index           =   6
      Left            =   3000
      TabIndex        =   19
      Top             =   1260
      Width           =   615
   End
   Begin VB.Label Label 
      Caption         =   "AGC"
      Height          =   255
      Index           =   0
      Left            =   1560
      TabIndex        =   17
      Top             =   1260
      Width           =   615
   End
   Begin VB.Label Read 
      Alignment       =   1  'Right Justify
      BorderStyle     =   1  'Fixed Single
      Height          =   255
      Left            =   1920
      TabIndex        =   16
      Top             =   600
      Width           =   855
   End
   Begin VB.Label Label 
      Caption         =   "MODE"
      Height          =   255
      Index           =   5
      Left            =   0
      TabIndex        =   14
      Top             =   1260
      Width           =   615
   End
   Begin VB.Label Label 
      Caption         =   "Rx"
      Height          =   255
      Index           =   3
      Left            =   0
      TabIndex        =   12
      Top             =   10
      Width           =   615
   End
   Begin VB.Label ConnState 
      BackColor       =   &H000000FF&
      BorderStyle     =   1  'Fixed Single
      Height          =   255
      Left            =   4560
      TabIndex        =   11
      ToolTipText     =   "Connection state"
      Top             =   0
      Width           =   855
   End
   Begin VB.Label FrqMax 
      Alignment       =   1  'Right Justify
      BorderStyle     =   1  'Fixed Single
      Height          =   255
      Left            =   600
      TabIndex        =   8
      Top             =   720
      Width           =   855
   End
   Begin VB.Label RomID 
      Alignment       =   1  'Right Justify
      BorderStyle     =   1  'Fixed Single
      Height          =   255
      Left            =   600
      TabIndex        =   7
      Top             =   480
      Width           =   855
   End
   Begin VB.Label Label 
      Caption         =   "FrqMax"
      Height          =   255
      Index           =   2
      Left            =   0
      TabIndex        =   6
      Top             =   720
      Width           =   615
   End
   Begin VB.Label Label 
      Caption         =   "ROMId"
      Height          =   255
      Index           =   1
      Left            =   0
      TabIndex        =   5
      Top             =   480
      Width           =   615
   End
   Begin VB.Label Label 
      Caption         =   "FRQ"
      Height          =   255
      Index           =   4
      Left            =   1560
      TabIndex        =   0
      Top             =   645
      Width           =   615
   End
End
Attribute VB_Name = "Test"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' ==================================================================================================
' A very very light testbed for the ReceiverCtl Active/X
' It demonstrates most of its fonctionnality
' B.VELLE
' ==================================================================================================
Private WithEvents Receiver As RECEIVERCTLLib.ReceiverDriver
Attribute Receiver.VB_VarHelpID = -1
Private Index As Integer
Private mButton As Integer
' ==================================================================================================
Private Sub RefreshMode(NewVal As MODTYPE)
    Dim i As Integer
    Mode.Clear
    Mode.Enabled = True         '   = Receiver.RxIsRemote(Index)
'   If (Receiver.RxIsConnected(Index) = False) Then Exit Sub
    For i = 0 To Receiver.RxModCount(Index) - 1
        If (Receiver.RxModExist(Index, i)) Then Mode.AddItem Receiver.RxModName(Index, i)
    Next i
    
    Dim j As MODTYPE
    For j = 0 To Receiver.RxModCount(Index) - 1
        If (NewVal = Receiver.RxModType(Index, Mode.List(j))) Then
            Mode.ListIndex = j
        End If
    Next j
    RefreshFilter Receiver.RxFltBW(Index)
    RefreshAgc Receiver.RxAgcSts(Index)
End Sub
' ==================================================================================================
Private Sub RefreshFilter(NewVal As Long)
    Dim i As Integer
    Filter.Clear
    Filter.Enabled = True       '   = Receiver.RxIsRemote(Index)
'   If (Receiver.RxIsConnected(Index) = False) Then Exit Sub
    For i = 0 To Receiver.RxFltCount(Index) - 1
        Filter.AddItem Format(Receiver.RxFltValue(Index, i), "@@@@@@") & " / " & Receiver.RxFltName(Index, Receiver.RxFltValue(Index, i))
    Next i
    
    Dim j As Integer
    For j = 0 To Receiver.RxFltCount(Index) - 1
       If (NewVal = Val(Trim(Filter.List(j)))) Then
            Filter.ListIndex = j
           Exit Sub
       End If
    Next j
End Sub
' ==================================================================================================
Private Sub RefreshAgc(NewVal As AGCTYPE)
    Dim i As Integer
    Agc.Clear
    Agc.Enabled = True      '   =Receiver.RxIsRemote(Index)
'   If (Receiver.RxIsConnected(Index) = False) Then Exit Sub
    For i = 0 To Receiver.RxAgcCount(Index) - 1
        If (Receiver.RxAgcExist(Index, i)) Then Agc.AddItem Trim(Receiver.RxAgcName(Index, i))
    Next i
    
    Dim j As AGCTYPE
    If (NewVal = AgcNone) Then Exit Sub
    For j = 0 To Receiver.RxAgcCount(Index) - 1
        If (NewVal = Receiver.RxAgcType(Index, Agc.List(j))) Then
            Agc.ListIndex = j
           Exit Sub
        End If
    Next j
End Sub
' ==================================================================================================
Private Sub RefreshNB(NewVal As NBLTYPE)
    NB.Clear
    NB.Enabled = True   '   = Receiver.RxIsRemote(Index)
'   If (Receiver.RxIsConnected(Index) = False) Then Exit Sub
    For i = 0 To Receiver.RxNBlCount(Index) - 1
        If (Receiver.RxNBlExist(Index, i)) Then NB.AddItem Receiver.RxNBlName(Index, i)
    Next i
    
    Dim j As NBLTYPE
    If (NewVal = NBNone) Then Exit Sub
    For j = 0 To Receiver.RxNBlCount(Index) - 1
        If (NewVal = Receiver.RxNBlType(Index, NB.List(j))) Then
            NB.ListIndex = j
           Exit Sub
        End If
    Next j
End Sub
' ==================================================================================================
Private Sub RefreshAtt(NewVal As ATTSTATE)
    Att.Clear
    Att.Enabled = True      '   = Receiver.RxIsRemote(Index)
'   If (Receiver.RxIsConnected(Index) = False) Then Exit Sub
    For i = 0 To Receiver.RxAttCount(Index) - 1
        If (Receiver.RxAttExist(Index, i)) Then Att.AddItem Receiver.RxAttName(Index, i)
    Next i
    
    Dim j As ATTSTATE
    If (NewVal = AttNone) Then Exit Sub
    For j = 0 To Receiver.RxAttCount(Index) - 1
        If (NewVal = Receiver.RxAttType(Index, Att.List(j))) Then
            Att.ListIndex = j
            Exit Sub
        End If
    Next j
End Sub
' ==================================================================================================
Private Sub RefreshFields()
    RefreshMode Receiver.RxMod(Index)
    RefreshFilter Receiver.RxFltBW(Index)
    RefreshAgc Receiver.RxAgcSts(Index)
    RefreshNB Receiver.RxNBlSts(Index)
    RefreshAtt Receiver.RxAttSts(Index)
    Read.Caption = Receiver.RxFrq(Index, False)
    BFO.Caption = Receiver.RxBFO(Index)
End Sub
' ==================================================================================================
Private Sub ClearFields()
    Mode.Clear
    Filter.Clear
    Agc.Clear
    NB.Clear
    Att.Clear
End Sub
' ==================================================================================================
Private Sub UpdateFields()
    RomID.Caption = Receiver.RxRomID(Index)
    FrqMax.Caption = Receiver.RxFrqMax(Index)
    FrqMin.Caption = Receiver.RxFrqMin(Index)
    
    If (Receiver.RxIsRemote(Index)) Then
        ConnState.BackColor = RGB(0, 255, 0)
    ElseIf (Receiver.RxIsConnected(Index)) Then
        ConnState.BackColor = RGB(255, 255, 0)
    Else
        ConnState.BackColor = RGB(255, 0, 0)
    End If
    
    Mode.Enabled = Receiver.RxIsRemote(Index)
    Filter.Enabled = Receiver.RxIsRemote(Index)
    Agc.Enabled = Receiver.RxIsRemote(Index)
    NB.Enabled = Receiver.RxIsRemote(Index)
    Att.Enabled = Receiver.RxIsRemote(Index)
End Sub
' ==================================================================================================
Private Sub Coupling_Click()
    Receiver.DrvForward = Coupling.Value
End Sub
' ==================================================================================================
Private Sub Form_Load()
    Set Receiver = New RECEIVERCTLLib.ReceiverDriver
    Receiver.DrvConfigure "Test", ConfLoad
    If (Receiver.RxCount = 0) Then Unload Me: Exit Sub
    For i = 0 To Receiver.RxCount - 1
        Driver.AddItem Receiver.RxName(i)
    Next i
    Driver.Selected(0) = True
End Sub
' ==================================================================================================
Private Sub Form_KeyPress(KeyAscii As Integer)
    Receiver.RxProcessKey Index, KeyAscii
End Sub
' ==================================================================================================
Private Sub Driver_Click()
    Index = Driver.ListIndex
    RefreshFields
    UpdateFields
End Sub
' ==================================================================================================
Private Sub Dialog_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)
    mButton = Shift
End Sub
' ==================================================================================================
Private Sub Dialog_Click()
    If (mButton = 1) Then
        Receiver.RxConfigure Index
    Else
       Receiver.DrvConfigure "Test", ConfDialog
       If (Receiver.RxCount = 0) Then Unload Me: Exit Sub
    End If
End Sub
' ==================================================================================================
Private Sub Connect_Click()
    Receiver.RxConnect Index, True
End Sub
' ==================================================================================================
Private Sub Disconnect_Click()
    Receiver.RxConnect Index, False
    UpdateFields
End Sub
' ==================================================================================================
Private Sub Local_Click()
    Receiver.RxRemote Index, False
    UpdateFields
End Sub
' ==================================================================================================
Private Sub Remote_Click()
    Receiver.RxRemote Index, True
    UpdateFields
End Sub
' ==================================================================================================
Private Sub Freq_Validate(Cancel As Boolean)
    If (Freq.Text = "") Then Exit Sub
    Receiver.RxFrq(Index, False) = Freq.Text
End Sub
' ==================================================================================================
Private Sub DeltaF_Validate(Cancel As Boolean)
    If (DeltaF.Text = "") Then Exit Sub
    Receiver.RxOffset(Index) = DeltaF.Text
End Sub
' ==================================================================================================
Private Sub Mode_Click()
    i = Receiver.RxModType(Index, Mode)
    Receiver.RxMod(Index) = i
    RefreshFilter Receiver.RxFltBW(Index)
    RefreshAgc Receiver.RxAgcSts(Index)
End Sub
' ==================================================================================================
Private Sub Agc_Click()
    Dim i As Integer
    i = Receiver.RxAgcType(Index, Agc)
    Receiver.RxAgcSts(Index) = i
End Sub
' ==================================================================================================
Private Sub NB_Click()
    Dim i As Integer
    i = Receiver.RxNBlType(Index, NB)
    Receiver.RxNBlSts(Index) = i
End Sub
' ==================================================================================================
Private Sub Att_Click()
    Dim i As Integer
    i = Receiver.RxAttType(Index, Att)
    Receiver.RxAttSts(Index) = i
End Sub
' ==================================================================================================
Private Sub Filter_Click()
     Receiver.RxFltBW(Index) = Val(Trim(Filter))
End Sub
' ==================================================================================================
Private Sub Receiver_DrvUpdated(ByVal Count As Long)
    If (Receiver.RxCount = 0) Then Unload Me: Exit Sub
    Driver.Clear
    For i = 0 To Receiver.RxCount - 1
        Driver.AddItem Receiver.RxName(i)
    Next i
End Sub
' ==================================================================================================
Private Sub Receiver_RxConnState(ByVal Index As Integer, ByVal Err As RECEIVERCTLLib.ConnErr)
    If (Driver.ListIndex <> Index) Then Exit Sub
    If (Err <> ConnectNoError) Then ConnState.BackColor = RGB(255, 0, 0): Exit Sub
    UpdateFields
End Sub
' ==================================================================================================
Private Sub Receiver_RxDataError(ByVal Index As Integer, ByVal Err As RECEIVERCTLLib.DataErr)
    If (Driver.ListIndex <> Index) Then Exit Sub
    UpdateFields
End Sub
' ==================================================================================================
Private Sub Receiver_RxFrqUpdated(ByVal Index As Integer, ByVal Freq As Long, ByVal Carr As Long)
    If (Driver.ListIndex <> Index) Then Exit Sub
    If (Receiver.RxIsConnected(Index) = False) Then Exit Sub
    Read.Caption = Freq
End Sub
' ==================================================================================================
Private Sub Receiver_RxModUpdated(ByVal Index As Integer, ByVal Mods As MODTYPE, ByVal Off As Long)
    If (Driver.ListIndex <> Index) Then Exit Sub
    RefreshMode Mods
    BFO.Caption = Off
End Sub
' ==================================================================================================
Private Sub Receiver_RxFltUpdated(ByVal Index As Integer, ByVal Filt As Long)
    If (Driver.ListIndex <> Index) Then Exit Sub
    RefreshFilter Filt
End Sub
' ==================================================================================================
Private Sub Receiver_RxAgcUpdated(ByVal Index As Integer, ByVal Sts As AGCTYPE, ByVal Lvl As Integer)
    If (Driver.ListIndex <> Index) Then Exit Sub
    RefreshAgc Sts
End Sub
' ==================================================================================================
Private Sub Receiver_RxNBlUpdated(ByVal Index As Integer, ByVal Sts As NBLTYPE, ByVal Lvl As Integer)
    If (Driver.ListIndex <> Index) Then Exit Sub
    RefreshNB Sts
End Sub
' ==================================================================================================
Private Sub Receiver_RxAttUpdated(ByVal Index As Integer, ByVal Sts As ATTSTATE, ByVal Lvl As Integer)
    If (Driver.ListIndex <> Index) Then Exit Sub
    RefreshAtt Sts
End Sub
' ==================================================================================================
Private Sub Receiver_RxHFFUpdated(ByVal Index As Integer, ByVal Sts As HFFSTATE)
    If (Driver.ListIndex <> Index) Then Exit Sub
'   RefreshHFF Sts
End Sub
' ==================================================================================================
Private Sub Receiver_RxSMtUpdated(ByVal Index As Integer, ByVal Freq As Long, ByVal Val As Integer, ByVal dB As Integer, ByVal SP As String)
    If (Driver.ListIndex <> Index) Then Exit Sub
    SMet = SP
End Sub
' ==================================================================================================


