VERSION 5.00
Begin VB.Form Ctltest 
   Caption         =   "CtlTest"
   ClientHeight    =   915
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   2820
   LinkTopic       =   "Form1"
   ScaleHeight     =   915
   ScaleWidth      =   2820
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton Enter 
      Caption         =   "Enter"
      Default         =   -1  'True
      Height          =   375
      Left            =   0
      TabIndex        =   3
      Top             =   480
      Width           =   855
   End
   Begin VB.TextBox Text 
      Height          =   375
      Left            =   0
      TabIndex        =   2
      Top             =   0
      Width           =   2775
   End
   Begin VB.CommandButton Hide 
      Caption         =   "Hide"
      Height          =   375
      Left            =   1920
      TabIndex        =   1
      Top             =   480
      Width           =   855
   End
   Begin VB.CommandButton Show 
      Caption         =   "Show"
      Height          =   375
      Left            =   960
      TabIndex        =   0
      Top             =   480
      Width           =   855
   End
End
Attribute VB_Name = "Ctltest"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'============================================================================================
' A short test for our WeatherCtl Active/X object
'============================================================================================
Const sInputFile As String = "debug.log"
'============================================================================================
Dim hDbgFile As Integer
Dim oWeather As WEATHERCTLLib.WeatherDialog
'============================================================================================
' Load test form
'============================================================================================
Private Sub Form_Load()
    '----------------------------------------------------------------------------------------
    ' Create the object
    '----------------------------------------------------------------------------------------
    Set oWeather = New WEATHERCTLLib.WeatherDialog
    '----------------------------------------------------------------------------------------
    ' Initialize it
    '----------------------------------------------------------------------------------------
    Dim bRes As Boolean
    bRes = oWeather.Create(True)
    '----------------------------------------------------------------------------------------
    ' Cannot be initialized
    '----------------------------------------------------------------------------------------
    If (Not bRes) Then
       Unload Me
       Exit Sub
    End If
    '----------------------------------------------------------------------------------------
    ' Open the input test file
    '----------------------------------------------------------------------------------------
    hDbgFile = FreeFile
    Open sInputFile For Input Access Read Shared As hDbgFile
    '----------------------------------------------------------------------------------------
    ' Gives our decoder a name that will be used as a registry key
    '----------------------------------------------------------------------------------------
    oWeather.NodeName = "TEST_NODE"
    '----------------------------------------------------------------------------------------
    ' Set decoding options
    '----------------------------------------------------------------------------------------
'   oWeather.MessageRelax = True
'   oWeather.DecoderRelax = True
'   oWeather.DecoderQuiet = True
    oWeather.DecoderResyn = True
    oWeather.LogStart = True
    '----------------------------------------------------------------------------------------
    ' Move decoder windows
    '----------------------------------------------------------------------------------------
    oWeather.Top = 200
    oWeather.Left = 200
    oWeather.Width = 8000
    oWeather.Height = 5000
    '----------------------------------------------------------------------------------------
    ' Set font size
    '----------------------------------------------------------------------------------------
    oWeather.FontSize = 7
End Sub
'============================================================================================
' Unload test form
'============================================================================================
Private Sub Form_Unload(Cancel As Integer)
    '----------------------------------------------------------------------------------------
    ' Close input file
    '----------------------------------------------------------------------------------------
    Close hDbgFile
    '----------------------------------------------------------------------------------------
    ' Delete our object
    '----------------------------------------------------------------------------------------
    oWeather.Destroy 0
    Set oWeather = Nothing
End Sub
'============================================================================================
' Send a record to the decoder
'============================================================================================
Private Sub Enter_Click()
    Dim hdata As String
    '----------------------------------------------------------------------------------------
    ' Whole file has been processed
    '----------------------------------------------------------------------------------------
    If (EOF(hDbgFile)) Then Exit Sub
    '----------------------------------------------------------------------------------------
    ' Get input line and print it
    '----------------------------------------------------------------------------------------
    Input #hDbgFile, hdata
    Text.Text = hdata
    '----------------------------------------------------------------------------------------
    ' Send it to the decoder with the CR/LF ending
    '----------------------------------------------------------------------------------------
    oWeather.Parse hdata & vbCrLf
End Sub
'============================================================================================
' Hide the decoder windows
'============================================================================================
Private Sub Hide_Click()
    oWeather.Show = False
End Sub
'============================================================================================
' Show the decoder windows
'============================================================================================
Private Sub Show_Click()
     oWeather.Show = True
End Sub
'============================================================================================

